<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xpath="http://www.w3.org/2005/xpath-functions"
    version="3.0"
    exclude-result-prefixes="xs fn pl xpath">
    
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="jsonFile" select="'input-example.json'" />

  <xsl:template match="/">
    <xsl:variable name="raw-json" select="json-to-xml(unparsed-text($jsonFile))"/>
    <Table key="PL_DEMO_PRODUCTS">
        <Items>
            <xsl:for-each select="$raw-json/xpath:array/xpath:map">
                <Item partition="ACTIVES">
                    <xsl:apply-templates select="xpath:map[@key='identifiers']/xpath:string"/>
                    <xsl:apply-templates select="xpath:map[@key='classification']/xpath:string"/>
                    <xsl:apply-templates select="xpath:map[@key='fields']/*"/>
                </Item>
            </xsl:for-each>
        </Items>
    </Table>
  </xsl:template>

   <xsl:template match="xpath:map[@key='identifiers']/xpath:string">
      <Identifier key="{@key}">
         <xsl:value-of select="text()"/>
      </Identifier>
   </xsl:template>
   
   <xsl:template match="xpath:map[@key='classification']/xpath:string">
      <Classification key="{@key}">
         <xsl:value-of select="text()"/>
      </Classification>
   </xsl:template>

   <xsl:template match="xpath:map[@key='fields']/*">
      <Field key="{@key}">
         <xsl:value-of select="text()"/>
      </Field>
   </xsl:template>

</xsl:stylesheet>
