<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:m="http://www.w3.org/2005/xpath-functions"
    version="3.0"
    exclude-result-prefixes="xs fn pl m">

    <xsl:output method="json" indent="yes" encoding="UTF-8" />

    <!-- For local tests only -->
    <!-- <xsl:param name="items_url" select="'./TESTS/items.xml'" />
    <xsl:param name="supplier" select="'SUPPLIERS'" />
    <xsl:param name="classification" select="'nomenclatureCarrefour'" />
    <xsl:param name="screen" select="'SUPPLIERS'" /> -->

    <xsl:param name="items_url" select="'./TESTS/items.xml'" />
    <xsl:param name="supplier" select="'FOURNISSEUR'" />
    <xsl:param name="classification" select="'TYPOLOGY'" />
    <xsl:param name="screen" select="'ALL_ATTRIBUTES_SUPPLIER'" />
    
    <xsl:template match="/">
        <!-- Control params -->
        <xsl:choose>
            <xsl:when test="$items_url = ''">
                <xsl:message terminate="yes">Missing param items_url in job.json</xsl:message>
            </xsl:when>
            <xsl:when test="$supplier = ''">
                <xsl:message terminate="yes">Missing param supplier in job.json</xsl:message>
            </xsl:when>
            <xsl:when test="$classification = ''">
                <xsl:message terminate="yes">Missing param classification in job.json</xsl:message>
            </xsl:when>
            <xsl:when test="$screen = ''">
                <xsl:message terminate="yes">Missing param screen in job.json</xsl:message>
            </xsl:when>
        </xsl:choose>

        <xsl:variable name="items" select="doc($items_url)/Table/Items/Item" />
        <xsl:variable name="schema" select="/Table/Schema" />

        <!-- Control param validity -->
        <xsl:choose>
            <xsl:when test="not($schema/Fields/Field[@key=$supplier])">
                <xsl:message terminate="yes">In job.json supplier value does not exists</xsl:message>
            </xsl:when>
            <xsl:when test="not($schema/Classifications/Classification[@key=$classification])">
                <xsl:message terminate="yes">In job.json classification value does not exists</xsl:message>
            </xsl:when>
            <xsl:when test="not($schema/Screens/Screen[@key=$screen])">
                <xsl:message terminate="yes">In job.json screen value does not exists</xsl:message>
            </xsl:when>
        </xsl:choose>

        
        <xsl:variable name="categories_expected">
            <xsl:variable name="count_commons" select="count($schema/Screens/Screen[@key=$screen]/Grid/Common/Section/*)" />
            <xsl:for-each select="$schema/Classifications/Classification[@key=$classification]/Categories/Category">
                <xsl:variable name="category_key" select="@key" />
                <xsl:variable name="screen_specific" select="$schema/Screens/Screen[@key=$screen]/Grid/Specific[@classification=$classification and @category=$category_key]" />
                <Category key="{$category_key}" title="{Title/string()}" expected="{$count_commons + count($screen_specific/Section/Column-Field)}">
                    <xsl:for-each select="$schema/Screens/Screen[@key=$screen]/Grid/Common/Section/*">
                        <Attribute key="{@key}" />
                    </xsl:for-each>
                    <xsl:for-each select="$screen_specific/Section/Column-Field">
                        <Attribute key="{@key}" />
                    </xsl:for-each>
                </Category>
            </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="active_category_keys" select="$categories_expected/Category/@key/string()" />
        
        <xsl:variable name="xmlForJson">
            <m:map>
                <m:map key="metadata">
                    <m:string key="title">Analyse du taux de complétion par fournisseur</m:string>
                    <m:array key="suppliers">
                        <xsl:for-each select="$schema/Fields/Field[@key=$supplier]/Options/Option">
                            <m:map>
                                <m:string key="key">
                                    <xsl:value-of select="@key" />
                                </m:string>
                                <m:string key="title">
                                    <xsl:value-of select="Title" />
                                </m:string>
                            </m:map>
                        </xsl:for-each>
                    </m:array>
                </m:map>
                <m:array key="metrics">
                    <xsl:variable name="common_key" select="$schema/Screens/Screen[@key=$screen]/Grid/Common/Section/*/@key/string()" />
                    <xsl:variable name="count_commons" select="count($common_key)" />
                    <!-- Filter only items on categories that are not archived = only active category key -->
                    <xsl:for-each-group select="$items[Classification[@key=$classification]=$active_category_keys]" group-by="Field[@key=$supplier]">
                        <xsl:variable name="supplier_key" select="current-grouping-key()" />
                        <xsl:variable name="items_supplier" select="current-group()" />
                        <xsl:variable name="count_items_supplier" select="count($items_supplier)" />
                        <m:map>
                            <m:string key="supplier_key">
                                <xsl:value-of select="$supplier_key" />
                            </m:string>
                            <m:number key="products">
                                <xsl:value-of select="$count_items_supplier" />
                            </m:number>
                            
                            <xsl:variable name="completion_by_category">
                                <xsl:for-each-group select="$items_supplier" group-by="Classification[@key=$classification]">
                                    <xsl:variable name="category_key" select="current-grouping-key()" />
                                    <xsl:variable name="items_supplier_category" select="current-group()" />
                                    <xsl:variable name="category" select="$categories_expected/Category[@key=$category_key]" />
                                    <xsl:variable name="items_count">
                                        <xsl:for-each select="$items_supplier_category">
                                            <!-- We need a distinc-values to not multiple count multiple-select -->
                                            <item_count><xsl:value-of select="count(distinct-values(./*[@key=$category/Attribute/@key]/@key))"/></item_count>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="reality" select="sum($items_count/item_count)" />
                                    <xsl:variable name="expected" select="$category/@expected * count($items_supplier_category)" />
                                    <xsl:if test="$reality != 0 and $expected != 0">
                                        <Category key="{$category/@key}" title="{$category/@title}" products="{count($items_supplier_category)}" completion="{format-number(($reality * 100) div $expected,'#.#')}" />  
                                    </xsl:if>                   
                                </xsl:for-each-group>
                            </xsl:variable>
                            <m:number key="completion">
                                <xsl:value-of select="format-number(avg($completion_by_category/Category/@completion),'#.#')"/>
                            </m:number>
                            <m:array key="by_category">
                                <xsl:for-each select="$completion_by_category/Category">
                                    <m:map>
                                        <m:string key="key"><xsl:value-of select="@key"/></m:string>
                                        <m:string key="title"><xsl:value-of select="@title"/></m:string>
                                        <m:number key="products"><xsl:value-of select="@products"/></m:number>
                                        <m:number key="completion"><xsl:value-of select="@completion"/></m:number>
                                    </m:map>
                                </xsl:for-each>
                            </m:array>
                        </m:map>
                    </xsl:for-each-group>
                </m:array>
            </m:map>
        </xsl:variable>
        <xsl:copy-of select="parse-json(xml-to-json($xmlForJson))" />
    </xsl:template>
</xsl:stylesheet>