# Product-Live Generic Job #1 - Media export

This task allows generic export of media associated with a list of items within a table, [more information here](https://learn.product-live.com/data-factory/resources/jobs/1-media-export/)

## Features

- Select whether to export the images or not
- Select whether to export the attachments or not
- Add optional resizing parameters for exported images
- Multiple languages support
- Select specifics fields to export


## Requirements

- A Product-Live account with at least one table
- An active Data-Factory pipeline

## Setup

- Before creating this job, it is necessary to create a Data-Factory variable, which is required for its operation. The `generic_job_1_media_export_table_key` variable is used to query the target table for our export. The expected value is the key of the target table.
- In case the target table is a shared table you need to set the "accountKey" parameter in the export-schema task. This parameter is used to specify the owner of the target table. The expected value is the key of the owner of the target table.


## Release Notes

### 1.0.3
- Folders management in the zip : possibility to choose which folders and subfolders to create in the zip
- Better filename banalization getting rid of specials characters

### 1.0.2
- Multi-languages support, one zip for each selected language
- Improved file extension detection and completed mime-type list
- Improved image resizing option with a option-list of choice : 250x250 pixels, 500x500 pixels etc..
- Possibility to choose the exported fields, all, only images, only attachments, or specifics fields.
- Optional options in the XSLT to : 
    - Keep and export the original-file-name of the files

### 1.0.1
- Allowing more file types in the export
- Management of multiple identifiers in the table in case an item has an empty one

### 1.0.0
Job first release. For more information, please refer to the [documentation](https://learn.product-live.com/data-factory/resources/jobs/1-media-export/).
